using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace EQTrack
{
    public partial class FormOptions : Form
    {
        //XMLSettings Globals.Settings = new XMLSettings("Globals.Settings");
        private bool readOptions = false;
        public FormOptions()
        {
            InitializeComponent();


            txtFUN.Text = Globals.htOptions["FUN"].ToString();
            txtMin_LAT.Text = Globals.htOptions["Min_LAT"].ToString();
            txtMax_LAT.Text = Globals.htOptions["Max_LAT"].ToString();
            txtMin_LON.Text = Globals.htOptions["Min_LON"].ToString();
            txtMax_LON.Text = Globals.htOptions["Max_LON"].ToString();
            txtMin_Battery.Text = Globals.htOptions["Min_Battery"].ToString();
            txtMax_Battery.Text = Globals.htOptions["Max_Battery"].ToString();
            txtMin_FIX.Text = Globals.htOptions["Min_FIX"].ToString();
            txtMin_SSI.Text = Globals.htOptions["Min_SSI"].ToString();
            txtSWV.Text = Globals.htOptions["SWV"].ToString();
            txtDBPath.Text = Globals.htOptions["Database"].ToString();
            txtMax_Units.Text = Globals.htOptions["Max_Units"].ToString();

            checkBoxChkDB.Checked = (bool)Globals.htOptions["ChkFactoryDB"];
            toolTipDB.SetToolTip(txtDBPath, txtDBPath.Text);
            toolTipDB.SetToolTip(txtFUN, "The Function code");
            toolTipDB.SetToolTip(txtMax_LAT, "The Max Latitude of the testing location.");
            toolTipDB.SetToolTip(txtMin_LAT, "The Min Latitude of the testing location.");
            toolTipDB.SetToolTip(txtMin_LON, "The Min Longitude of the testing location.");
            toolTipDB.SetToolTip(txtMax_LON, "The Max Longitude of the testing location.");
            toolTipDB.SetToolTip(txtMin_Battery, "The Min voltage level of the Battery");
            toolTipDB.SetToolTip(txtMax_Battery, "The Max voltage level of the Battery");
            toolTipDB.SetToolTip(txtMin_FIX, "The min number of FIX");
            toolTipDB.SetToolTip(txtMin_SSI, "The min number of SSI");
            toolTipDB.SetToolTip(txtSWV, "The Software version");
            toolTipDB.SetToolTip(txtMax_Units, "The Max number of units can be imported from the Excel file");
            toolTipDB.SetToolTip(checkBoxChkDB, "Check in the Factory database when scanning the blackhawk units");
            readOptions = true;
        }

        private void btnSaveConf_Click(object sender, EventArgs e)
        {

            Globals.Settings.Set(Globals.SettingsPathOptions + "FUN", txtFUN.Text);
            Globals.Settings.Set(Globals.SettingsPathOptions + "Min_LAT", txtMin_LAT.Text);
            Globals.Settings.Set(Globals.SettingsPathOptions + "Max_LAT", txtMax_LAT.Text);
            Globals.Settings.Set(Globals.SettingsPathOptions + "Min_LON", txtMin_LON.Text);
            Globals.Settings.Set(Globals.SettingsPathOptions + "Max_LON", txtMax_LON.Text);
            Globals.Settings.Set(Globals.SettingsPathOptions + "Min_Battery", txtMin_Battery.Text);
            Globals.Settings.Set(Globals.SettingsPathOptions + "Max_Battery", txtMax_Battery.Text);
            Globals.Settings.Set(Globals.SettingsPathOptions + "Min_FIX", txtMin_FIX.Text);
            Globals.Settings.Set(Globals.SettingsPathOptions + "SWV", txtSWV.Text);
            Globals.Settings.Set(Globals.SettingsPathOptions + "Min_SSI", txtMin_SSI.Text);
            Globals.Settings.Set(Globals.SettingsPathOptions + "Database", txtDBPath.Text);
            Globals.Settings.Set(Globals.SettingsPathOptions + "ChkFactoryDB", checkBoxChkDB.Checked);
            Globals.Settings.Set(Globals.SettingsPathOptions + "Max_Units", Int32.Parse(txtMax_Units.Text));
			Globals.Settings.Save(Globals.SettingsFilename);

            Globals.htOptions["FUN"] = txtFUN.Text;
            Globals.htOptions["Min_LAT"] = txtMin_LAT.Text;
            Globals.htOptions["Max_LAT"] = txtMax_LAT.Text;
            Globals.htOptions["Min_LON"] = txtMin_LON.Text;
            Globals.htOptions["Max_LON"] = txtMax_LON.Text;
            Globals.htOptions["Min_Battery"] = txtMin_Battery.Text;
            Globals.htOptions["Max_Battery"] = txtMax_Battery.Text;
            Globals.htOptions["Min_FIX"] = txtMin_FIX.Text;
            Globals.htOptions["SWV"] = txtSWV.Text;
            Globals.htOptions["Min_SSI"] = txtMin_SSI.Text;
            Globals.htOptions["Database"] = txtDBPath.Text;
            Globals.htOptions["Max_Units"] = Int32.Parse(txtMax_Units.Text);
            Globals.htOptions["ChkFactoryDB"] = checkBoxChkDB.Checked;

            Globals.resetPassed = true;
            MessageBox.Show("settings are saved");
            this.Dispose();


        }

        private void btnCancelConf_Click(object sender, EventArgs e)
        {
            this.Dispose();
        }

        private void txtMin_LAT_TextChanged(object sender, EventArgs e)
        {

            if (readOptions)
            {
                btnSaveConf.Enabled = true;
            }
            
        }

        private void btnSelectDBPath_Click(object sender, EventArgs e)
        {

            OpenFileDialog dialog = new OpenFileDialog();
            dialog.Filter =
               "Access files (*.mdb)|*.mdb|All files (*.*)|*.*";
            dialog.InitialDirectory = ".";
            dialog.Title = "Select The Database Path";
            if (dialog.ShowDialog() == DialogResult.OK)
            {

                txtDBPath.Text = dialog.FileName;
                toolTipDB.SetToolTip(txtDBPath, txtDBPath.Text);

            }
        }

        private void txtDBPath_MouseHover(object sender, EventArgs e)
        {

            toolTipDB.SetToolTip(txtDBPath, txtDBPath.Text);
        }

        private void panel1_Paint(object sender, PaintEventArgs e)
        {

        }

    }
}